# Changelog

All notable changes to CloudScale Page Views are documented here.
Format follows [Keep a Changelog](https://keepachangelog.com/en/1.0.0/).

## [2.4.0] - 2026-02-27

### Added
- Stats page: All Time banner showing lifetime total views and posts with views (includes Jetpack imports)
- Stats page: All Time Top Posts panel ranked by lifetime meta totals
- Top Posts widget: Phase 2 backfill from lifetime meta when windowed log data is sparse (transition period after Jetpack migration)
- Top Posts widget: dual display showing "X trending · Y total" when windowed and lifetime counts differ

### Changed
- Dashboard widget: purple gradient banner with pink accents replacing blue theme
- Dashboard widget: chart bars, tab indicators, progress bars and view counts all use pink/purple palette
- Top Posts widget: orange accent pagination buttons, grey date/view text
- Recent Posts widget: orange accent pagination, grey date/view text
- Recent Posts widget: current page indicator uses orange gradient

### Fixed
- Top Posts widget Phase 2 backfill: replaced WP_Query meta_query (silently failed on some installs) with direct SQL join for reliable results

## [2.3.0] - 2026-02-27

### Added
- Tracking filter: configurable post type filter controls which content types the beacon records views on (Settings > CloudScale Views, bottom of page)
  - Defaults to Posts only, so pages, home page, and other content types are not tracked
  - Persisted as cspv_track_post_types option
  - Beacon loader checks post type before firing; untracked types silently skip recording
- Recent Posts widget (Appearance > Widgets > CloudScale: Recent Posts)
  - Paginated list of recent posts with date and CloudScale view counts
  - Server side pagination via query string parameters
  - Replaces the standalone CloudScale Paginated Recent Posts plugin
  - Uses cspv_get_view_count() for all time view display (no Jetpack dependency)
  - Pagination styled with CloudScale blue gradient for current page indicator

### Changed
- Beacon loader now respects cspv_track_post_types setting
- Untracked singular pages fall through to fetch mode so archive style count elements still work

### Note
- After updating, deactivate the standalone CloudScale Paginated Recent Posts plugin
- Re add the widget under Appearance > Widgets (it will appear as CloudScale: Recent Posts)

## [2.2.0] - 2026-02-27

### Added
- Auto display of view counts on single posts with no theme editing required
- Settings page under Settings > CloudScale Views with options for:
  - Display position (before content, after content, both, or off)
  - Post type selection (posts, pages, or any public custom post type)
  - Customisable icon and suffix text
  - Live preview of the counter format
- Manual theme integration instructions shown on the settings page

### Changed
- Default auto display position is "before content" (enabled out of the box)

## [2.1.0] - 2026-02-27

### Added
- Top Posts sidebar widget (Appearance > Widgets > CloudScale: Top Posts)
  - Paginated list with thumbnail, date and formatted view count
  - Configurable ranking window (last N days or all time) using the cspv_views log table
  - Falls back to denormalised meta counter when log table is empty (e.g. after migration)
  - Configurable pool size, posts per page, thumbnail width, and sort order
- Merged the standalone CloudScale Top Posts Widget plugin into this plugin

### Changed
- Widget class renamed from AB_Top_Posts_Widget to CSPV_Top_Posts_Widget
- Widget CSS classes renamed from abw- prefix to cspv-tp- prefix
- All Jetpack stats_get_csv() dependencies removed from widget
- Widget ID changed from ab_top_posts_widget to cspv_top_posts_widget

### Note
- After updating, deactivate the standalone CloudScale Top Posts Widget plugin
- Re add the widget under Appearance > Widgets (it will appear as CloudScale: Top Posts)
- Existing widget settings will need to be reconfigured as the widget ID has changed

## [1.1.0] - 2026-02-27

### Added
- Live statistics dashboard under Tools > Page Views
  - Summary cards: total views, posts tracked, views today
  - Top 10 posts table showing both log count and meta count so drift is visible
  - Recent 50 raw view log entries auto-refreshing every 10 seconds
  - Endpoint diagnostic Ping button to confirm REST endpoint is reachable and not cached
  - Cloudflare Cache Rule setup reminder with exact configuration values
- Hashed IP address stored in the log table (SHA-256 + wp_salt) for future deduplication
- User agent stored in log rows for future bot filtering
- Cache-busting query parameter on beacon.js URL to prevent Cloudflare from serving a stale script
- Full suite of cache-bypass headers on the REST endpoint:
  - Cache-Control: no-store
  - Cloudflare-CDN-Cache-Control: no-store
  - CDN-Cache-Control: no-store
  - Surrogate-Control: no-store
  - Vary: Cookie
- Diagnostics ping endpoint at /wp-json/cloudscale-page-views/v1/ping
- Debug console logging in beacon.js when WP_DEBUG is true
- CHANGELOG.md (this file)
- LICENSE.txt (GPL-2.0+)
- Structured into includes/ and admin/ subdirectories

### Changed
- Refactored monolithic plugin file into separate includes for maintainability
- beacon.js now receives postId and debug flag via wp_localize_script

### Fixed
- Cloudflare could cache beacon.js itself and serve a page-specific script to the wrong page

## [1.0.0] - 2026-02-27

### Added
- Initial release
- JavaScript beacon fires POST to /wp-json/cloudscale-page-views/v1/record/{id} after page load
- View count stored in post meta (_cspv_view_count) for fast display in themes
- Raw view log in wp_cspv_views database table
- Sortable Views column in Posts > All Posts admin list
- Template functions: cspv_get_view_count() and cspv_the_view_count()
- Cache-Control headers on REST endpoint to prevent Cloudflare caching
- live count update via .cspv-live-count CSS class
