<?php
/**
 * Plugin Name:  CloudScale Page Views
 * Plugin URI:   https://andrewbaker.ninja
 * Description:  Accurate page view tracking via a JavaScript beacon that bypasses Cloudflare cache. Includes auto display on posts, Top Posts and Recent Posts sidebar widgets, and a live statistics dashboard under Tools.
 * Version:      2.5.5
 * Author:       Andrew Baker
 * Author URI:   https://andrewbaker.ninja
 * License:      GPL-2.0+
 * License URI:  https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:  cloudscale-page-views
 * Requires PHP: 7.4
 * Requires at least: 6.0
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

define( 'CSPV_VERSION',    '2.6.0' );
define( 'CSPV_META_KEY',   '_cspv_view_count' );
define( 'CSPV_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'CSPV_PLUGIN_URL', plugin_dir_url( __FILE__ ) );

require_once CSPV_PLUGIN_DIR . 'includes/database.php';
require_once CSPV_PLUGIN_DIR . 'includes/ip-throttle.php';
require_once CSPV_PLUGIN_DIR . 'includes/rest-api.php';
require_once CSPV_PLUGIN_DIR . 'includes/beacon.php';
require_once CSPV_PLUGIN_DIR . 'includes/template-functions.php';
require_once CSPV_PLUGIN_DIR . 'includes/jetpack-migration.php';
require_once CSPV_PLUGIN_DIR . 'includes/top-posts-widget.php';
require_once CSPV_PLUGIN_DIR . 'includes/recent-posts-widget.php';
require_once CSPV_PLUGIN_DIR . 'includes/auto-display.php';
require_once CSPV_PLUGIN_DIR . 'admin/admin-columns.php';
require_once CSPV_PLUGIN_DIR . 'admin/dashboard-widget.php';
require_once CSPV_PLUGIN_DIR . 'admin/stats-page.php';

register_activation_hook( __FILE__, 'cspv_activate' );

// Auto-upgrade table schema on version change (no deactivate/reactivate needed)
add_action( 'admin_init', function() {
    $stored = get_option( 'cspv_version', '0' );
    if ( version_compare( $stored, CSPV_VERSION, '<' ) ) {
        cspv_upgrade_table();
        update_option( 'cspv_version', CSPV_VERSION );
    }
} );
